/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.editor;

import com.quantumdata.fmteditor.FmtUI;
import com.quantumdata.fmteditor.editor.Problem;
import com.quantumdata.fmteditor.editor.ProblemTableModel;
import com.quantumdata.fmteditor.fmtwidgets.FmtHeaderCellRenderer;
import com.quantumdata.widgets.QDStdUI;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemTable
extends JTable {
    private ProblemTableModel m_model = new ProblemTableModel();

    public ProblemTable() {
        this.setModel(this.m_model);
        TableColumn tableColumn = this.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(50);
        tableColumn.setMaxWidth(50);
        tableColumn.setMinWidth(50);
        tableColumn.setCellRenderer(new IdCellRenderer());
        tableColumn = this.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(50);
        tableColumn.setMaxWidth(50);
        tableColumn.setMinWidth(50);
        tableColumn.setCellRenderer(new IdCellRenderer());
        tableColumn = this.getColumnModel().getColumn(0);
        int n = FmtUI.getIcon(0).getIconWidth();
        tableColumn.setPreferredWidth(n);
        tableColumn.setMaxWidth(n);
        tableColumn.setMinWidth(n);
        tableColumn.setCellRenderer(new TypeCellRenderer());
        this.setForeground(Color.white);
        this.setBackground(QDStdUI.getBackground());
        this.setSelectionBackground(QDStdUI.getSelectedColor());
        this.setSelectionForeground(Color.black);
        this.getTableHeader().setDefaultRenderer(new FmtHeaderCellRenderer());
        this.getTableHeader().setReorderingAllowed(false);
    }

    public void addProblem(Problem problem) {
        this.m_model.addProblem(problem);
    }

    public void clear() {
        this.m_model.clear();
    }

    public void setProblems(Collection<Problem> collection) {
        this.m_model.setProblems(collection);
    }

    private class IdCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public IdCellRenderer() {
            super("");
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Problem problem = ProblemTable.this.m_model.getProblem(n);
            this.setHorizontalAlignment(0);
            this.setBorder(null);
            this.setOpaque(true);
            this.setBackground(QDStdUI.getBackground());
            this.setForeground(QDStdUI.getActionForeground());
            switch (n2) {
                case 1: {
                    this.setText(String.format("%04d", problem.getId()));
                    break;
                }
                case 2: {
                    int n3 = problem.getErrorCode();
                    if (n3 > 0) {
                        this.setText(String.format("%04d", problem.getErrorCode()));
                        break;
                    }
                    this.setText("----");
                }
            }
            return this;
        }
    }

    private class TypeCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public TypeCellRenderer() {
            super("");
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 != 0) {
                return this;
            }
            Problem problem = ProblemTable.this.m_model.getProblem(n);
            this.setHorizontalAlignment(0);
            this.setBorder(null);
            this.setOpaque(true);
            this.setBackground(QDStdUI.getBackground());
            switch (problem.getType()) {
                case ERROR: {
                    this.setIcon(FmtUI.getIcon(2));
                    break;
                }
                case WARNING: {
                    this.setIcon(FmtUI.getIcon(1));
                    break;
                }
                case NOTE: {
                    this.setIcon(FmtUI.getIcon(0));
                }
            }
            return this;
        }
    }
}

